@echo off
setlocal enabledelayedexpansion

:: Configure your driver name (without extension)
set DRIVER_NAME=axcl_pcie

echo ======================================================
echo Completely removing driver: %DRIVER_NAME%
echo ======================================================

:: Step 1. Find INF file
for /f "tokens=2 delims=:" %%A in ('pnputil /enum-drivers ^| findstr /i %DRIVER_NAME% ^| findstr /i oem') do (
    set INF_NAME=%%A
    set INF_NAME=!INF_NAME: =!
)

if "%INF_NAME%"=="" (
    echo [INFO] No matching INF found in system driver list. It may have been already removed.
) else (
    echo [INFO] Found driver INF: %INF_NAME%
    echo [ACTION] Uninstalling driver package...
    pnputil /enum-drivers
    pnputil /delete-driver %INF_NAME% /uninstall /force
    devcon remove PCI\VEN_1F4B&DEV_0650
)

:: Step 2. Stop and delete service
echo [ACTION] Stopping driver service...
sc stop %DRIVER_NAME% >nul 2>&1
echo [ACTION] Deleting driver service...
sc delete %DRIVER_NAME% >nul 2>&1

:: Step 3. Delete driver file
set DRIVER_PATH=%SystemRoot%\System32\drivers\%DRIVER_NAME%.sys
if exist "%DRIVER_PATH%" (
    echo [ACTION] Deleting %DRIVER_PATH%
    del "%DRIVER_PATH%" >nul 2>&1
    if exist "%DRIVER_PATH%" (
        echo [WARN] File is locked, attempting to take ownership...
        takeown /F "%DRIVER_PATH%" >nul
        icacls "%DRIVER_PATH%" /grant administrators:F >nul
        del "%DRIVER_PATH%" >nul 2>&1
        if exist "%DRIVER_PATH%" (
            echo [ERROR] Unable to delete %DRIVER_PATH%. Please check if it is loaded in kernel.
        ) else (
            echo [OK] Driver file forcibly deleted.
        )
    ) else (
        echo [OK] Driver file deleted.
    )
) else (
    echo [INFO] Driver file not found.
)

:: Step 4. Delete remaining DriverStore folders
for /d %%D in (%SystemRoot%\System32\DriverStore\FileRepository\%DRIVER_NAME%*.inf_amd64*) do (
    echo [ACTION] Deleting DriverStore folder: %%D
    takeown /F "%%D" /A /R >nul
    icacls "%%D" /grant administrators:F /T >nul
    rmdir /S /Q "%%D"
)

:: Step 5. Remove registry leftovers
echo [ACTION] Cleaning registry entries...
reg delete "HKLM\SYSTEM\CurrentControlSet\Services\%DRIVER_NAME%" /f >nul 2>&1

echo ======================================================
echo [DONE] Driver %DRIVER_NAME% cleanup completed!
echo ======================================================
pause
endlocal
